//
//  RTBGameDAO.m
//  RoadTripBingo
//
//  Created by Juan Navas Martin on 3/11/14.
//  Copyright (c) 2014 Juan Navas. All rights reserved.
//

#import "RTBGameDAO.h"
/*
GAMES
 gameID     - INTEGER PRIMARY KEY
 playerName - VARCHAR
 startDate  - TEXT
 endDate    - TEXT
 gotBingo   - BOOL
*/

@implementation RTBGameDAO

- (NSString *) getDbURL{
    NSArray *paths;
    NSString *docsUrl;
    NSString *dbURL;
    
    paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    docsUrl = [paths objectAtIndex:0];
    
    NSFileManager *manager = [NSFileManager defaultManager];
    
    dbURL = [docsUrl stringByAppendingPathComponent:@"RoadTripBingo.sqlite"];
    
    if (![manager fileExistsAtPath:dbURL]) {
        [manager copyItemAtPath:[[[NSBundle mainBundle] resourcePath] stringByAppendingPathComponent:@"RoadTripBingo.sqlite"] toPath:dbURL error:NULL];
    }
    return dbURL;
}

- (NSMutableArray *) getFinishedGames {
    
    NSMutableArray *games = [[NSMutableArray alloc]init];
    NSString *url = [self getDbURL];
    NSDateFormatter *df = [[NSDateFormatter alloc]init];
    NSString *date;
    [df setDateFormat:@"yyyyMMddHHmmss"];
    
    if (sqlite3_open([url UTF8String], &db) != SQLITE_OK){
        NSLog(@"There is a problem login to Database: %@\nError Code: %d", url, sqlite3_errcode(db));
    }
    else {
        const char *sqlStatement = "SELECT GAMEID, PLAYERNAME, STARTDATE, ENDDATE, ENDDATE - STARTDATE AS TIMEINTERVAL FROM GAMES WHERE GOTBINGO=1 ORDER BY TIMEINTERVAL ASC";
        
        sqlite3_stmt *statement;
        
        if (sqlite3_prepare_v2(db, sqlStatement, -1, &statement, NULL) != SQLITE_OK) {
            NSLog(@"Error preparing statement: %s\nErrorCode: %d ", sqlStatement, sqlite3_errcode(db));
        }
        else {
            while(sqlite3_step(statement) == SQLITE_ROW){
                
                RTBGame *myGame = [[RTBGame alloc]init];
                myGame.gameID = sqlite3_column_int(statement, 0);
                myGame.playerName = [NSString stringWithUTF8String:(char *) sqlite3_column_text(statement, 1) ];
                date = [NSString stringWithUTF8String:(char *) sqlite3_column_text(statement, 2) ];
                myGame.startDate = [df dateFromString:date];
                date = [NSString stringWithUTF8String:(char *) sqlite3_column_text(statement, 3) ];
                myGame.endDate = [df dateFromString:date];
                
                [games addObject:myGame];
            }
        }
        sqlite3_finalize(statement);
    }
    sqlite3_close(db);
    
    //NSLog(@"Total Games Count: %d", [games count]);
    return games;
}
- (NSMutableArray *) getSavedGames {
    
    NSMutableArray *games = [[NSMutableArray alloc]init];
    NSString *url = [self getDbURL];
    NSDateFormatter *df = [[NSDateFormatter alloc]init];
    NSString *date;
    [df setDateFormat:@"yyyyMMddHHmmss"];
    
    if (sqlite3_open([url UTF8String], &db) != SQLITE_OK){
        NSLog(@"There is a problem login to Database: %@\nError Code: %d", url, sqlite3_errcode(db));
    }
    else {
        const char *sqlStatement = "SELECT GAMEID, PLAYERNAME, STARTDATE, ENDDATE FROM GAMES WHERE GOTBINGO=0 ORDER BY STARTDATE ASC";
        
        sqlite3_stmt *statement;
        
        if (sqlite3_prepare_v2(db, sqlStatement, -1, &statement, NULL) != SQLITE_OK) {
            NSLog(@"Error preparing statement: %s\nErrorCode: %d ", sqlStatement, sqlite3_errcode(db));
        }
        else {
            while(sqlite3_step(statement) == SQLITE_ROW){
                
                RTBGame *myGame = [[RTBGame alloc]init];
                myGame.gameID = sqlite3_column_int(statement, 0);
                myGame.playerName = [NSString stringWithUTF8String:(char *) sqlite3_column_text(statement, 1) ];
                date = [NSString stringWithUTF8String:(char *) sqlite3_column_text(statement, 2) ];
                myGame.startDate = [df dateFromString:date];
                date = (char *)sqlite3_column_text(statement, 3) ? [NSString stringWithUTF8String:(char *) sqlite3_column_text(statement, 3)] : nil;
                myGame.endDate = [df dateFromString:date];
                
                [games addObject:myGame];
            }
        }
        sqlite3_finalize(statement);
    }
    sqlite3_close(db);
    
    //NSLog(@"Total Games Count: %d", [games count]);
    return games;
    
}

- (RTBGame *) getCurrentGame {
    
    RTBGame *myGame;
    NSString *url = [self getDbURL];
    NSDateFormatter *df = [[NSDateFormatter alloc]init];
    NSString *date;
    [df setDateFormat:@"yyyyMMddHHmmss"];
    
    if (sqlite3_open([url UTF8String], &db)!= SQLITE_OK) {
        NSLog(@"GET CURRENT GAME: There is a problem login to Database: %@\nError code: %d", url, sqlite3_errcode(db));
    }
    else {
        const char *sqlStatement = "SELECT GAMEID, PLAYERNAME, STARTDATE FROM GAMES WHERE ENDDATE IS NULL";
        sqlite3_stmt *statement;
        
        if (sqlite3_prepare_v2(db, sqlStatement, -1, &statement, NULL) != SQLITE_OK) {
            NSLog(@"GetCurrentGame: Error preparing statement: %s\nError Code: %d", sqlStatement, sqlite3_errcode(db));
        }
        else {
            while(sqlite3_step(statement) == SQLITE_ROW){
                if (!myGame) {
                    myGame = [[RTBGame alloc]init];
                }
                myGame.gameID = sqlite3_column_int(statement, 0);
                myGame.playerName = [NSString stringWithUTF8String:(char *) sqlite3_column_text(statement, 1) ];
                date = [NSString stringWithUTF8String:(char *) sqlite3_column_text(statement, 2) ];
                myGame.startDate = [df dateFromString:date];
                //NSLog(@"While: RTBGame retrieved: %@", myGame);
            }
        }
        sqlite3_finalize(statement);
    }
    sqlite3_close(db);
    NSLog(@"RTBGame retrieved: %@", myGame);

    return myGame;
}

- (long) createGame: (RTBGame *)game {
    NSString *url = [self getDbURL];
    long code=0;
    
    if((sqlite3_open([url UTF8String], &db) != SQLITE_OK)){
        NSLog(@"CREATE GAME: There was a problem opening the DB. Error code: %d", sqlite3_errcode(db));
    }
    else {
        
        NSDateFormatter *df = [[NSDateFormatter alloc]init];
        [df setDateFormat:@"yyyyMMddHHmmss"];
        
        //NSString *sqlInsert = [NSString stringWithFormat:@"INSERT INTO GAMES (playerName, startDate, endDate, gotBingo) VALUES ('%@', %@, %@, %d)", game.playerName, [df stringFromDate:game.startDate], [df stringFromDate:game.endDate], game.gotBingo];
        
        const char *sqlStatement ="INSERT INTO GAMES (playerName, startDate, endDate, gotBingo) VALUES (?, ?, ?, ?)";
        //[sqlInsert UTF8String];
        sqlite3_stmt *statement;
        
        if((sqlite3_prepare_v2(db, sqlStatement, -1, &statement, NULL)) != SQLITE_OK){
            NSLog(@"CREATE GAME: There was a problem preparing the statement: %s.\nError Code: %d", sqlStatement, sqlite3_errcode(db));
        }
        else {
            sqlite3_bind_text(statement, 1, [game.playerName UTF8String], -1, NULL);
            sqlite3_bind_text(statement, 2, [[df stringFromDate:game.startDate] UTF8String], -1, NULL);
            sqlite3_bind_text(statement, 3, [[df stringFromDate:game.endDate] UTF8String], -1, NULL);
            sqlite3_bind_int(statement, 4, game.gotBingo);
            
            if((code = sqlite3_step(statement)) == SQLITE_DONE) {
                code = (long)sqlite3_last_insert_rowid(db);
                
            }
            else {
                NSLog(@"CREATE GAME: There was a problem executing statement. Error: %ld.\n Sql Error Code= %d", code, sqlite3_errcode(db));
            }
        }
        sqlite3_finalize(statement);
        sqlite3_close(db);
   }
    return code;    
}
- (void) saveCurrentGame: (RTBGame *) game {
    
    NSString *url = [self getDbURL];
    
    if(sqlite3_open([url UTF8String], &db) != SQLITE_OK){
        NSLog(@"SAVE CURRENT GAME: There was a problem opening the DB.\nError Code: %d", sqlite3_errcode(db));
    }
    else {
        NSDateFormatter *df = [[NSDateFormatter alloc]init];
        [df setDateFormat:@"yyyyMMddHHmmss"];
        //NSString *sqlUpdate = [NSString stringWithFormat:@"UPDATE GAMES SET endDate = '%@', gotBingo = %d WHERE id = %d", game.endDate, game.gotBingo, game.gameID];
        
        const char *sqlStatement ="UPDATE GAMES SET endDate = ?, gotBingo = ? WHERE gameID = ?";
        //[sqlUpdate UTF8String];
        sqlite3_stmt *statement;
    
        if(sqlite3_prepare_v2(db, sqlStatement, -1, &statement, NULL) != SQLITE_OK){
            NSLog(@"SAVE CURRENT GAME: There was a problem preparing the statement: %s.\nError code: %d", sqlStatement, sqlite3_errcode(db));
        }
        else {

            sqlite3_bind_text(statement, 1, [[df stringFromDate:game.endDate] UTF8String], -1, NULL);
            sqlite3_bind_int(statement, 2, game.gotBingo);
            sqlite3_bind_int(statement, 3, game.gameID);
            
            if(sqlite3_step(statement) != SQLITE_DONE){
                NSLog(@"SAVE CURRENT GAME: There was a problem executing statement.\n Sql Error Code= %d", sqlite3_errcode(db));
            }
        }
        sqlite3_finalize(statement);
    }
    sqlite3_close(db);
}
- (void) deleteGame: (RTBGame *) game {
    NSString *url = [self getDbURL];
    
    if(sqlite3_open([url UTF8String], &db) != SQLITE_OK){
        NSLog(@"DELETE GAME: There was a problem opening the DB.\nError Code: %d", sqlite3_errcode(db));
    }
    else {
        NSDateFormatter *df = [[NSDateFormatter alloc]init];
        [df setDateFormat:@"yyyyMMddHHmmss"];
        
        const char *sqlStatement ="DELETE FROM GAMES WHERE gameID = ?";
        sqlite3_stmt *statement;
        
        if(sqlite3_prepare_v2(db, sqlStatement, -1, &statement, NULL) != SQLITE_OK){
            NSLog(@"DELETE GAME: There was a problem preparing the statement: %s.\nError code: %d", sqlStatement, sqlite3_errcode(db));
        }
        else {
            sqlite3_bind_int(statement, 1, game.gameID);
            
            if(sqlite3_step(statement) != SQLITE_DONE){
                NSLog(@"DELETE GAME: There was a problem executing statement.\n Sql Error Code= %d", sqlite3_errcode(db));
            }
        }
        sqlite3_finalize(statement);
    }
    sqlite3_close(db);
}
@end
